﻿function trim(str) {
    return str.replace(/(^\s+)|(\s+$)/g, "");
}

function trimAll(str) {
    return str.replace(/\s+/g, "");
}

function textCounter(obj, Number) {
    var charcnt = $(obj).val().length;
    if (charcnt > Number) {
        $(obj).val($(obj).val().substring(0, Number));
    }

}
function ClickForgotPw(obj, type) {
    var toggleSet = $(obj).attr('data-toggle-trigger');
    var $hiddenPart = $('[data-toggle-pair="' + toggleSet + '"].toggle-pair-hidden');
    var $visiblePart = $('[data-toggle-pair="' + toggleSet + '"]:not(.toggle-pair-hidden)');
    $hiddenPart.removeClass('toggle-pair-hidden');
    $visiblePart.addClass('toggle-pair-hidden');
    if (type == "cancel") { $("#btnSend").show(); $("#txtSend_error").hide(); $("#txtForgotEmail").val(""); }
}

function ChangeSendFunction(accountType) {
    if (accountType == "agency") {
        $('#btnSend').attr('onclick', "AgencyForgotPassword(this);")
    }
    if (accountType == "agent") {
        $('#btnSend').attr('onclick', "Send(this, 'agent');")
    }
}

function InputValidation(obj, msg, type) {
    var flag = true;
    var objValue = $(obj).val() != undefined ? trim($(obj).val()) : "";
    var $errMsg = $("#div" + trimAll(msg) + "Err");

    if (msg != "Phone2" && (objValue == "" || objValue == "undefined" || objValue == null)) {
        $errMsg.html("* Required");
        $errMsg.show();
        if ($errMsg.next() != undefined) {
            $errMsg.next().hide();
        }
        flag = false;
    }
    else {
        $errMsg.hide();
        if (type != "") {
            flag = MyAccountInputValidationRule(type, objValue, msg);
        }

    }
    return flag;
}
function KeyUpTrim(obj) {
    $(obj).val(trim($(obj).val()));
}

function PhoneKeyup(obj) {
    KeyUpTrim(obj);
    var phoneNum = $(obj).val().replace("(", "").replace(")", "").replace("-", "");
    if (phoneNum.length > 10) {
        $(obj).val(phoneNum.substring(0, 10));
    }
    $(obj).val($(obj).val().replace(/^(\d{3})(\d{3})(\d{4})+$/, "($1)$2-$3"));
}
function ValidationNumber(obj) {
    KeyUpTrim(obj);
    $(obj).val($(obj).val().replace(/[^0-9]/g, ''));
}
function ZipCodeKeyup(obj) {
    var countryId = $("#sltCountry").val();
    if (countryId != "88238" && countryId != "-1")
        KeyUpTrim(obj);
}

function InputValidationLoginPassword(obj, msg, type) {
    var flag = true;
    var objValue = $(obj).val() != undefined ? $.trim($(obj).val()) : "";
    var $errMsg = $("#div" + trimAll(msg) + "Err");
    var reg = "";
    var errMsg = '<div>' + 'Please input the correct ' + msg + '.' + '</div>';
    if (type != "") {
        reg = /^[a-zA-Z0-9_-`~!@#$%^&*()_+<>?:"{},.\/;'[\]]*$/;             
        errMsg = "<div>Passwords do not match.</div>";
    }
    if (!reg.test(objValue)) {
        $errMsg.html(errMsg).show();
        flag = false;
    } else {
        $errMsg.hide();
    }

    if (objValue === "") {
        $errMsg.html("* Required").show();
    }
    else {
        $errMsg.hide();
    }
    return flag;
}

function MyAccountInputValidationRule(type, objValue, msg) {
    var flag = true;
    var $errMsg = msg == "Passport number" || msg == "Card Number" || msg == "CardHolders Name" || msg == "First Name" || msg == "Last Name" || msg == "Zip Code" ? $("#div" + trimAll(msg) + "Err") : $("#div" + trim(msg) + "Err");
    var reg = "";
    msg = msg == "Phone1" || msg == "Phone2" ? "Phone" : msg;
    var errMsg = "Please input the correct " + msg + ".";
    switch (type) {
        case "number":
        case "cardNumber":
        case "date":
            reg = /^[0-9]*$/;
            break;
        case "zipCode":
            return ZipCodeValidation(type, objValue, $errMsg, errMsg);
        case "email":
            reg = /^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;
            errMsg = "Invalid email address.";
            break;
        case "password":
            reg = /^[a-zA-Z0-9_-`~!@#$%^&*()_+<>?:"{},.\/;'[\]]*$/;            
            errMsg = "Passwords do not match";
            break;
        case "phone":
            reg = /^\((\d{3})\)(\d{3})-(\d)+$/;
            break;
        case "passportNum":
            reg = /^[0-9a-zA-Z]+$/;
            htmlErrMsg = "Please input the correct Passport number.";
            objValue = $("#txtPassportNum").val();
            break;
        case "month":
            reg = /^[0-9]*$/;
            objValue = Changemonth(objValue);
            if (objValue == 0) objValue = "mm"; else objValue = objValue.toString();
            htmlErrMsg = "Please ensure the date of issue is correct .";
            break;
        case "companyname":
            reg = /^[a-zA-Z0-9_-`~!@#$%^&*()_+<>?:"{},.\/;'[\](^\s+)|(\s+$)|\s+]*$/; 
            errMsg = "Invalid company name.";
            break;
        case "companyaddress":
            reg = /^[a-zA-Z0-9_-`~!@#$%^&*()_+<>?:"{},.\/;'[\](^\s+)|(\s+$)|\s+]*$/; 
            errMsg = "Invalid company address.";
            break;
        default:
            reg = msg == "CardHolders Name" ? /^[a-zA-Z\s/]/g : /^[a-zA-Z\s]/g;
            break;
    }
    if (type == "phone" || (msg == "Phone2" && trimAll(objValue) != "")) {
        if (!reg.test(trimAll(objValue)) && !(/^[0-9]*$/).test(trimAll(objValue))) {
            var str = errMsg.replace("1", "");
            str = str.replace("2", "");
            $errMsg.html(str);
            $errMsg.show();
            flag = false;
        }
        else {
            $errMsg.hide();
            flag = SpecialValidation(type, objValue, $errMsg)
        }
    }
    else {
        if (!reg.test(trim(objValue))) {
            $errMsg.html(errMsg);
            $errMsg.show();
            if ($errMsg.next() != null) {
                $errMsg.next().hide();
            }
            flag = false;
        }
        else {
            $errMsg.hide();
            flag = SpecialValidation(type, objValue, $errMsg)
        }
    }
    return flag;
}
function SpecialValidation(type, objValue, $errMsg) {
    var flag = true;
    switch (type) {
        case "password":
            flag = CheckPasswordLength(objValue, $errMsg);
            break;
        case "cardNumber":
            flag = CardNumFormatValidation(objValue, $errMsg);
            break;
        case "date":
            flag = CardExpiryDateValidation(objValue, $errMsg, type);
            break;
        default: break;
    }
    return flag;
}

function NameFormatting(obj, msg, type) {
    var returnStr = "";
    if (msg == "CardHolders Name") {
        $(obj).val($(obj).val().replace(/[^a-zA-Z\s/]/g, ''));
    }
    else {
        $(obj).val($(obj).val().replace(/[^a-zA-Z\s]/g, ''));
    }
    var str = $(obj).val();
    if (str != "" && str != undefined) {
        if (msg == "Last Name") {
            returnStr = NameFormatStrLastName(str);
        }
        else {
            returnStr = NameFormatStr(str);
        }

        $(obj).val(returnStr);
    }
}
function NameFormatStrLastName(str) {
    var strList = str.split(' ');
    for (var i = 0; i < strList.length; i++) {
        if (i == 0) {
            str = strList[i].substring(0, 1).toUpperCase() + strList[i].slice(1).toLowerCase();
        }
        else {
            str += " " + strList[i];
        }
    }
    return str;
}
function NameFormatStr(str) {
    var returnStr = "";
    var strArry = str.split('/');
    if (strArry.length > 0) {
        var tempStr = "";
        for (var i = 0; i < strArry.length; i++) {
            if (strArry[i] == "") tempStr += "/";
            else {
                tempStr += NameFormatStrWithSpaceCharacter(strArry[i]) + "/";
            }
        }
        returnStr = tempStr != "" ? tempStr.substring(0, tempStr.length - 1) : tempStr;
    }
    else {
        returnStr = NameFormatStrWithSpaceCharacter(str);
    }
    return returnStr;
}

function WithOutInterval(str) {
    return str.substring(0, 1).toUpperCase() + str.slice(1).toLowerCase();
}

function NameFormatStrWithSpaceCharacter(str) {
    return str.toLowerCase().split(' ').map(function (repalceStr) { return (repalceStr.substring(0, 1).toUpperCase() + repalceStr.slice(1).toLowerCase()); }
    ).join(' ');
}

function NameFormatStrWithDiagonal(str) {
    return str.toLowerCase().split('/').map(function (repalceStr) { return (repalceStr.substring(0, 1).toUpperCase() + repalceStr.slice(1).toLowerCase()); }
    ).join('/');
}

function PhoneValidation(obj, num, i, msg) {
    KeyUpTrim(obj);
    var flag = true;
    var reg = /^[0-9]*$/;
    var phone = trim($(obj).val());
    var length = phone.length;
    var $errMsg = $("#div" + msg + i + "Err");

    if ((i == 1 || i == 0) && (phone == "" || phone == null || phone == "undefined")) {
        if ($("#txtPhone0").val() == "" && $("#txtPhone1").val() == "" && $("#txtPhone2").val() == "" && $("#txtPhone3").val() == "") {
            $errMsg.html("* Required");
            $errMsg.show();
            flag = false;
        }
    } else {
        $errMsg.hide();
        if (!reg.test(phone)) {
            $(obj).val(phone);
            $errMsg.html("Invalid Phone Number");
            $errMsg.show();
            flag = false;
        }
        else {
            $errMsg.hide();
            if (i > 0) {
                InputNext(num, length, obj)
            }
        }
    }
    return flag;
}
function CheckPasswordLength(str, $errMsg) {
    var flag = true;
    const digitRegex = /\d/;
    const characterRegex = /[a-zA-Z]/;
    const legalRegex = /^[a-zA-Z0-9_-`~!@#$%^&*()_+<>?:"{},.\/;'[\]]*$/;    
    var $errMsg2 = $errMsg.next();
    $errMsg.hide();
    $errMsg2.hide();
    if (!legalRegex.test(trim(str))) {
        $errMsg.html("<div>Passwords do not match.</div>");
        $errMsg.show();
        flag = false;
    }
    else {
        if (str.length < 12) {
            $errMsg2.html("<div>Must be at least 12 characters</div>");
            $errMsg2.show();
            flag = false;
        }
        if (!(digitRegex.test(str) && characterRegex.test(str))) {
            $errMsg.html("<div>Must contain at least one letter and one number</div>");
            $errMsg.show();
            flag = false;
            if (str.length >= 12) {
                $errMsg2.hide();
            }
        }
    }
    if (flag) {
        $errMsg.hide();
        $errMsg2.hide();
    }
    return flag;
}
function GetCustomerInfo(whichOne, operation) {
    var affordableWorldUserId = $("#hidEmailAddress").val();
    var $divInfo = $("#div" + whichOne);
    var section = $divInfo.parent(".accordion");
    var clientType = $("#hidType").val();
    if (section.attr('data-state') == "close" || section.attr('data-state') == undefined || (operation == "Delete" || operation == "Add" || operation == "Edit" || operation == "Back")) {
        HideDiv(operation);
        if (whichOne != null && whichOne != "" && whichOne != undefined) {
            $.ajax({
                type: "post",
                data: {
                    "whichOne": whichOne,
                    "clientType": clientType
                },
                url: "/Account/GetCustomerInfo",
                datatype: "json",
                success: function (result) {
                    $("#divAccountInfo").html("");
                    $("#divPersonalInfo").html("");
                    $("#divCreditCards").html("");
                    $("#divBillingAddress").html("");
                    $("#divTravelerInformation").html("");
                    if ($divInfo != undefined) {
                        section.attr('data-state', 'open');
                        $divInfo.html(result);
                        bindTogglePassword();
                        setTimeout(function () {
                            $divInfo.find(".accordion__body").css("max-height", "100%");
                            $divInfo.find(".accordion__body").css("opacity", "1");
                            $divInfo.show("500");
                        }, 100);
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    if (XMLHttpRequest.status == 1001) {
                        eval(XMLHttpRequest.ResponseText);
                    } else {
                    }
                }
            });
        }
    }
    else {
        HideDiv(operation);
    }
}

function HideDiv(operation) {
    if (operation != "Delete" && operation != "Add" && operation != "Edit") {
        $("div[name='partialInfo']").each(function (i, e) {
            $(e).find(".accordion__body").css("max-height", "0");
            $(e).find(".accordion__body").css("opacity", "0");
            $(e).hide("500");
        });
    }
}

function IsRemove(Id, whichOne, clientUserId) {
    $("#remove-" + whichOne).on("click", function () {
        DeleteAnInformation(Id, whichOne, clientUserId);
    });
}

function DeleteAnInformation(Id, whichOne, clientUserId) {
    if (Id != "" && Id != null && Id != undefined && whichOne != "" && whichOne != null && whichOne != undefined) {
        var clientType = $("#hidType").val();
        $.ajax({
            type: "post",
            url: "/Account/DeleteAnInformation",
            data: {
                "Id": Id, "whichOne": whichOne, "clientUserId": clientUserId, "clientType": clientType
            },
            success: function (result) {
                if (result == "Delete failed!") {
                    $("#" + whichOne + "Error").html(result).css("background-color", "rgba(238, 39, 0, 0.5)");
                    $("#" + whichOne + "Error").show();
                    setTimeout(function () { $("#" + whichOne + "Error").fadeOut("slow"); }, 5000);
                }
                else {
                    $("#" + whichOne + "Error").hide();
                    GetCustomerInfo(whichOne, "Delete");
                    $("#div" + whichOne).focus();
                }
            }
        });
    }
}

function AddOrEditInfo(operation, Id, whichOne, loginType) {
    if (operation != null && operation != "") {
        var $divAddOrEditInfo = "";
        var $form = "";
        switch (whichOne) {
            case "CreditCards":
                $form = $("#formCreditCardList");
                $divAddOrEditInfo = $("#new-credit-card");
                break;
            case "BillingAddress":
                $form = $("#formBillingAddressList");
                $divAddOrEditInfo = $("#new-billing-address");
                break;
            case "PersonalInfo":
                $form = $("#formPersonalInfo");
                break;
            case "TravelerInformation":
                $form = $("#formTravelerInformationList");
                $divAddOrEditInfo = $("#new-traveler-information");
                break;
        }
        var clientType = $("#hidType").val();
        $.ajax({
            type: "post",
            data: { "operation": operation, "Id": Id, "whichOne": whichOne, "loginType": clientType },
            url: "/Account/GetAddOrEditInfo",
            success: function (result) {
                if (operation == "Add") {
                    $divAddOrEditInfo.html(result);
                    $divAddOrEditInfo.toggle();
                }
                else if (operation == "Edit" && $form != "") {
                    $form.html(result);
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                if (XMLHttpRequest.status == 1001) {
                    eval(XMLHttpRequest.ResponseText);
                } else {
                }
            }
        });
    }
}


function TravelerInformationInputValidation(obj, msg, type, changeDate) {
    var flag = true;
    var objValue = trim($(obj).val());
    var $errMsg = $("#div" + trimAll(msg) + "Err");
    type = msg == "Middle Name" && $("[name='chkMiddleName']").is(":checked") ? "" : type;
    if (msg == "ExpiryDate" || msg == "BirthDate") {
        if (changeDate == "save") {
            if (msg == "ExpiryDate" && ($("#sltExpiryDate_Month").val() == "MMM" || $("#sltExpiryDate_Day").val() == "DD" || $("#sltExpiryDate_Year").val() == "YYYY")) {
                $("#divExpiryDateErr").html("Please ensure the date of issue is correct. ");
                $("#divExpiryDateErr").show();
                flag = false;
                return flag;
            }
            if (msg == "BirthDate" && ($("#sltBirthDate_Month").val() == "MMM" || $("#sltBirthDate_Day").val() == "DD" || $("#sltBirthDate_Year").val() == "YYYY")) {
                $("#divBirthDateErr").html("Please ensure the date of birth is correct.");
                $("#divBirthDateErr").show();
                flag = false;
                return flag;
            }
        }
    }
    if (type == "gender") {
        var checkNum = 0;
        $("[name='rdoGender']").each(function (i, e) {
            if ($(e).is(":checked")) {
                checkNum += 1;
            }
        });
        if (checkNum == 0) {
            $errMsg.html("Please select the Gender ");
            $errMsg.show();
            flag = false;
        } else { $errMsg.hide(); }
    }
    else if ((msg == "Middle Name" && !$("[name='chkMiddleName']").is(":checked")) && (objValue == "" || objValue == undefined || objValue == null)) {

        $errMsg.html("* Required");
        $errMsg.show();
        flag = false;
    }
    else if (msg != "Gender" && msg != "Middle Name" && (objValue == "" || objValue == undefined || objValue == null)) {
        if (window.location.href.toLowerCase().indexOf("/zh/") > -1 || window.location.href.toLowerCase().indexOf("/zh-cn/") > -1) {
            $errMsg.html("* 必填");
        }
        else {
            $errMsg.html("* Required");
        }
        $errMsg.show();
        flag = false;
    }
    else {
        $errMsg.hide();
        if (type != "") {
            flag = MyAccountInputValidationRule(type, objValue, msg);
        }
    }
    return flag;
}


function ChangeDate(obj, whichone, typeOfNum, str) {
    if (str != "day") {
        $("option[name='" + whichone + "Day-31']").show();
        $("option[name='" + whichone + "Day-30']").show();
        $("option[name='" + whichone + "Day-29']").show();
        var month = $("#slt" + whichone + "_Month").val();
        var year = $("#slt" + whichone + "_Year").val();
        var day = $("#slt" + whichone + "_Day").val();
        var sltDay = $("#slt" + whichone + "_Day").val();
        var selectValue = day;
        if (month == "Feb") {
            $("option[name='" + whichone + "Day-31'").hide();
            $("option[name='" + whichone + "Day-30'").hide();
            if (year % 4 == 0 && year % 100 != 0) {
                selectValue = day == 30 || day == 31 ? 29 : day;
            }
            else if (year % 4 != 0 || (year % 4 == 0 && year % 100 == 0)) {
                $("option[name='" + whichone + "Day-29'").hide();
                selectValue = day == 30 || day == 31 || day == 29 ? 28 : day;
            }
        }
        else {
            if (month == "Apr" || month == "Jun" || month == "Sep" || month == "Nov") {
                $("option[name='" + whichone + "Day-31'").hide();
                selectValue = day == 31 ? 30 : day;
            }
        }
        $(sltDay).val(selectValue);
    }
    flag &= TravelerInformationInputValidation($(obj), whichone, typeOfNum);
    if (whichone == "ExpiryDate" && $("#sltExpiryDate_Month").val() != "MMM" && $("#sltExpiryDate_Day").val() != "DD" && $("#sltExpiryDate_Year").val() != "YYYY") {
        var flag = true;
        var selector = whichone == "ExpiryDate" ? "sltExpiryDate" : "sltBirthDate";
        flag &= TravelerInformationInputValidation($("#" + selector + "_Month"), whichone, "month");
        flag &= TravelerInformationInputValidation($("#" + selector + "_Day"), whichone, "date");
        flag &= TravelerInformationInputValidation($("#" + selector + "_Year"), whichone, "date");
        if (flag) {
            var passportNum = trim($("#txtPassportNum").val());
            if (passportNum != "" && passportNum != null && passportNum != undefined) {
                var $errMsg = $("#divPassportnumberErr");
                if (PassportNumValidation(passportNum, $errMsg)) {
                    return true;
                }
                else return false;
            }
        }
        else return false;
    }
    return true;
}


function Changemonth(Month) {
    var Mon = 0;
    if (Month == "Jan") {
        Mon = 1;
    } else if (Month == "Feb") {
        Mon = 2;
    } else if (Month == "Mar") {
        Mon = 3;
    } else if (Month == "Apr") {
        Mon = 4;
    } else if (Month == "May") {
        Mon = 5;
    } else if (Month == "Jun") {
        Mon = 6;
    } else if (Month == "Jul") {
        Mon = 7;
    } else if (Month == "Aug") {
        Mon = 8;
    }
    else if (Month == "Sep") {
        Mon = 9;
    }
    else if (Month == "Oct") {
        Mon = 10;
    } else if (Month == "Nov") {
        Mon = 11;
    } else if (Month == "Dec") {
        Mon = 12;
    }
    return Mon;
}

function SaveAnInformation(operation, Id, whichOne) {
    var jsonObj = {};
    var flag = true;
    var strInfo = "";
    jsonObj = CreditCardsDataValidationForSaveInfo(operation, Id);
    switch (whichOne) {
        case "CreditCards":
            jsonObj = CreditCardsDataValidationForSaveInfo(operation, Id);
            strInfo = "This credit card already exists.";
            break;
        case "BillingAddress":
            jsonObj = BillingAddressDataValidationForSaveInfo(Id);
            strInfo = "This billing address already exists.";
            break;
        case "TravelerInformation":
            jsonObj = TravelerInformationDataValidationForSaveInfo(Id);
            strInfo = "This companion already exists.";
            break;
    }
    if (jsonObj != "") {
        var clientType = $("#hidType").val();
        $.ajax({
            type: "post",
            url: "/Account/IsRepetition",
            data: {
                "jsonObj": JSON.stringify(jsonObj),
                "operation": operation,
                "whichOne": whichOne,
                "clientType": clientType
            },
            success: function (result) {
                if (result == "Repetition") {
                    $("#" + whichOne + "Error").html(strInfo).css("background-color", "rgba(238, 39, 0, 0.5)");
                    $("#" + whichOne + "Error").show();
                    setTimeout(function () { $("#" + whichOne + "Error").fadeOut("slow"); }, 5000);
                    flag = false;
                }
                else {
                    $("#" + whichOne).hide();
                    DealWithAjax(jsonObj, operation, whichOne);
                }
            },
            error: function (e) {
                alert(e.statusText)
            }
        });
    }
}

function CreditCardsDataValidationForSaveInfo(operation, Id) {
    var jsonObj = {};
    var flag = true;

    jsonObj.ClientUserId = $("#hidUserId").val();
    jsonObj.IsDefault = $("#hidIsDefult").val() != undefined && $("#hidIsDefult").val() == "False" ? true : $("#chkIsDefault").is(":checked");
    jsonObj.AdminCardHolderId = Id;
    if (operation == "Add") {
        flag &= InputValidation($("#txtCardNumber"), 'Card Number', 'cardNumber');
        flag &= InputValidation($("#txtCardHolderName"), 'CardHolders Name', 'letter')
    }
    flag &= InputValidation($("#sltMonth"), 'Date', 'date') && InputValidation($("#sltYear"), 'Date', 'date');
    if (operation == "Add" && flag) {
        var cardNumber = trim($("#txtCardNumber").val());
        jsonObj.CardHolderName = trim($("#txtCardHolderName").val());
        jsonObj.CardNumber = cardNumber.substring(cardNumber.length - 4, cardNumber.length);
        jsonObj.CardType = cardNumber.substring(0, 1) == "4" ? "Visa" : "MasterCard";
        jsonObj.FullCardNumber = cardNumber;
    }
    if (flag) {
        jsonObj.CardExpiration = trim($("#sltMonth").val() + "/01 " + trim($("#sltYear").val()));
        return jsonObj;
    }
    return "";
}
function BillingAddressDataValidationForSaveInfo(Id) {
    var jsonObj = {};
    var flag = true;

    var $firstName = $("#txtFirstName");
    var $lastName = $("#txtLastName");
    var $password2 = "#txtCreatePassword";
    var $phone = $("#txtPhoneNum");
    var $addressLine1 = $("#txtAddressLine1");
    var $addressLine2 = $("#txtAddressLine2");
    var $zipCode = $("#txtZipCode");
    var $city = $("#txtCity");
    var $state = $("#txtState").css("display") == "none" ? $("#sltState") : $("#txtState");
    var $country = $("#sltCountry");

    flag &= InputValidation($firstName, 'First Name', 'letter');
    flag &= InputValidation($lastName, 'Last Name', 'letter');
    flag &= InputValidation($addressLine1, 'Address', '');
    flag &= InputValidation($zipCode, 'Zip Code', 'zipCode');
    flag &= InputValidation($city, 'City', '');
    flag &= ($("#txtState").css("display") == "block" ? InputValidation($state, 'State', 'letter') : true);
    flag &= ($("#txtOthersCountry").css("display") == "block" ? InputValidation($country, 'Country', 'letter') : true);
    flag &= InputValidation($phone, 'Phone', 'phone');

    if (flag) {
        jsonObj.ClientUserId = $("#hidUserId").val();
        jsonObj.IsDefault = $("#hidIsDefult").val() != undefined && $("#hidIsDefult").val() == "False" ? true : $("#chkIsDefault").is(":checked");
        jsonObj.AdminCardHolderId = Id;
        jsonObj.Id = Id;
        jsonObj.FirstName = trim($firstName.val());
        jsonObj.LastName = trim($lastName.val());
        jsonObj.CountryId = trim($country.val());
        jsonObj.CountryName = trim($("#sltCountry option:selected").text());
        jsonObj.AddressLine1 = trim($addressLine1.val());
        jsonObj.AddressLine2 = trim($addressLine2.val());
        jsonObj.State = $("#sltState").css("display") == "none" ? $("#txtState").val() : trim($("#sltState").val());
        jsonObj.City = trim($city.val());
        jsonObj.ZipCode = trim($zipCode.val());
        jsonObj.Phone = trim($phone.val());
        return jsonObj;
    }
    return "";
}
function TravelerInformationDataValidationForSaveInfo(Id) {
    var jsonObj = {};
    var flag = true;
    var $firstName = $("#txtFirstName");
    var $lastName = $("#txtLastName");
    var $middleName = $("#txtMiddleName");
    var $gender = $("[name='rdoGender']");
    var $birthDate_Month = $("#sltBirthDate_Month");
    var $birthDate_Day = $("#sltBirthDate_Day");
    var $birthDate_Year = $("#sltBirthDate_Year");
    var $passportNum = $("#txtPassportNum");
    var $nationality = $("#sltNationality");
    var $expiryDate_Month = $("#sltExpiryDate_Month");
    var $expiryDate_Day = $("#sltExpiryDate_Day");
    var $expiryDate_Year = $("#sltExpiryDate_Year");
    var $countryOfResidence = $("#sltCountryOfResidence");

    flag &= TravelerInformationInputValidation($firstName, 'First Name', 'letter');
    flag &= TravelerInformationInputValidation($lastName, 'Last Name', 'letter');
    flag &= TravelerInformationInputValidation($middleName, "Middle Name", "letter");
    flag &= TravelerInformationInputValidation($gender, "Gender", "gender");
    flag &= TravelerInformationInputValidation($birthDate_Month, "BirthDate", "month", "save");
    flag &= TravelerInformationInputValidation($birthDate_Day, "BirthDate", "date", "save");
    flag &= TravelerInformationInputValidation($birthDate_Year, "BirthDate", "date", "save");
    flag &= TravelerInformationInputValidation($passportNum, "Passport number", "passportNum");
    flag &= TravelerInformationInputValidation($nationality, "Country", "number");
    flag &= TravelerInformationInputValidation($expiryDate_Month, "ExpiryDate", "month", "save");
    flag &= TravelerInformationInputValidation($expiryDate_Day, "ExpiryDate", "date", "save");
    flag &= TravelerInformationInputValidation($expiryDate_Year, "ExpiryDate", "date", "save");
    flag &= TravelerInformationInputValidation($countryOfResidence, "Country Of Residence", "number");
    if (flag) {
        var birthDate_Month = $birthDate_Month.find("option:selected").val();
        var expiryDate_Month = $expiryDate_Month.find("option:selected").val();
        jsonObj.Id = Id;
        jsonObj.ClientUserId = $("#hidUserId").val();
        jsonObj.FirstName = trim($firstName.val());
        jsonObj.LastName = trim($lastName.val());
        jsonObj.MiddleName = !$("[name='chkMiddleName']").is(":checked") ? trim($middleName.val()) : "";
        jsonObj.Gender = $("input[name='rdoGender']:checked").val();
        jsonObj.DateOfBirth = $birthDate_Year.find("option:selected").val() + "-" + Changemonth(birthDate_Month) + "-" + $birthDate_Day.find("option:selected").val();
        jsonObj.PassportNumber = trim($passportNum.val());
        jsonObj.CountryNameOfNationality = trim($nationality.find("option:selected").text());
        jsonObj.CountryIdOfNationality = $nationality.find("option:selected").val();
        jsonObj.ExpiryDate = $expiryDate_Year.find("option:selected").val() + "-" + Changemonth(expiryDate_Month) + "-" + $expiryDate_Day.find("option:selected").val();
        jsonObj.CountryNameOfResidence = trim($countryOfResidence.find("option:selected").text());
        jsonObj.CountryIdOfResidence = $countryOfResidence.find("option:selected").val();
        jsonObj.AdminUserId = $("#hidAdminUserId").val();
        return jsonObj;
    }
    else
        return "";
}
function DealWithAjax(jsonObj, operation, whichOne) {
    if (jsonObj == "" || jsonObj == null || jsonObj == "undefined") return false;
    if (operation == "" || operation == null || operation == "undefined") return false;
    if (whichOne == "" || whichOne == null || whichOne == "undefined") return false;
    var clientType = $("#hidType").val();
    $.ajax({
        type: "post",
        data: {
            "jsonObj": JSON.stringify(jsonObj),
            "operation": operation,
            "whichOne": whichOne,
            "clientType": clientType
        },
        url: "/Account/SaveAnInformation",
        success: function (result) {
            GetCustomerInfo(whichOne, operation)
        },
    });
}

function SaveEditAccountInformation(obj, operation) {
    var flag = true;
    var $ritzUserID = operation == "Add" ? $("#txtCreateEmailAddress") : $("#hidEmailAddress");
    var $firstName = $("#txtFirstName");
    var $lastName = $("#txtLastName");
    var $password2 = "#txtCreatePassword";
    var $phoneNum1 = $("#txtPhoneNum1");
    var $phoneNum2 = $("#txtPhoneNum2");
    var $addressLine1 = $("#txtAddressLine1");
    var $addressLine2 = $("#txtAddressLine2");
    var $city = $("#txtCity");
    var $state = $("#txtState").css("display") == "none" ? $("#sltState") : $("#txtState");
    var $country = $("#txtOthersCountry").css("display") == "none" ? $("#sltCountry") : $("#txtOthersCountry");
    var $password = $("#txtCreatePassword");
    var $ConfirmPassword = $("#txtCreateConfirmPassword");
    var $zipCode = $("#txtZipCode");
    flag &= InputValidation($ritzUserID, 'CreateEmailAddress', 'email');
    flag &= InputValidation($firstName, 'First Name', 'letter');
    flag &= InputValidation($lastName, 'Last Name', 'letter');
    flag &= InputValidation($phoneNum1, 'Phone1', 'number');
    flag &= InputValidation($phoneNum2, 'Phone2', 'number');

    flag &= (operation == "Add" ? InputValidation($password, 'CreatePassword', 'password') && InputValidation($ConfirmPassword, 'CreateConfirmPassword', 'password') : true);
    if (flag && operation == "Add") {
        if (trim($password.val()) != trim($ConfirmPassword.val())) {
            $("#divCreateConfirmPasswordErr").html("Entered passwords differ!");
            $("#divCreateConfirmPasswordErr").show();
            flag = false;
            $($password).focus(function () {
                $("#divCreateConfirmPasswordErr").hide();
            });
            $($ConfirmPassword).focus(function () {
                $("#divCreateConfirmPasswordErr").hide();
            });
            $($CurrentPassword).focus(function () {
                $("#divCreateComfirmPasswordErr").hide();
            });
        }
        else {
            $("#divCreateConfirmPasswordErr").hide();
        }
    }
    if (flag && operation == "Edit") {
        flag &= InputValidation($addressLine1, 'Address', '');
        flag &= InputValidation($city, 'City', '');
        flag &= ($("#txtState").css("display") == "block" ? InputValidation($state, 'State', 'letter') : true);
        flag &= ($("#txtOthersCountry").css("display") == "block" ? InputValidation($country, 'Country', 'letter') : true);
        flag &= InputValidation($zipCode, 'Zip Code', 'zipCode');
    }
    if (flag) {
        var phone1 = trim($phoneNum1.val());
        var phone2 = $phoneNum2.val() != undefined ? trim($phoneNum2.val()) : "";
        var countryId = $("#txtOthersCountry").css("display") == "none" ? $("#sltCountry").val() : -1;
        var othersCountry = $("#txtOthersCountry").css("display") == "none" ? "" : $("#txtOthersCountry").val();

        clientMod = {};
        clientMod.Subscribed = $("#Subscribed").prop("checked");
        clientMod.UserID = trim($ritzUserID.val());
        clientMod.LastName = trim($lastName.val());
        clientMod.FirstName = trim($firstName.val());
        clientMod.Phone1 = phone1;
        clientMod.Phone2 = phone2;
        clientMod.Phone1AreaCode = $("[name='sltAreaCode']").find("option:selected").data("areacode");
        clientMod.CountryIdOfPhone1AreaCode = $("[name='sltAreaCode']").find("option:selected").data("countryid");
        if (phone2 != "") {
            clientMod.Phone2AreaCode = $("[name='sltAreaCode2']").find("option:selected").data("areacode");
            clientMod.CountryIdOfPhone2AreaCode = $("[name='sltAreaCode2']").find("option:selected").data("countryid");
        }
        if (operation == "Edit") {
            clientMod.CountryId = countryId;
            clientMod.OthersCountry = othersCountry;
            clientMod.AddressLine1 = trim($addressLine1.val());
            clientMod.AddressLine2 = trim($addressLine2.val());
            clientMod.City = trim($city.val());
            clientMod.State = trim($state.val());
            clientMod.ZipCode = trim($zipCode.val());
        }
        else if (operation == "Add") {
            clientMod.Password2 = trim($password.val());
        }
        if (operation == "Edit") {
            $.ajax({
                type: 'POST',
                url: "/Account/SaveAccountInformation",
                data: {
                    "jsonObj": JSON.stringify(clientMod), "operation": operation
                },
                dataType: "text",
                beforeSend: function () {
                    $("#imgLoader").css("display", "initial");
                },
                success: function (data) {
                    $("#imgLoader").hide();
                    if (data == "failed") {
                        if (operation == "Add") {
                            $("#divErrorInfo").html("Create failed!");
                            $("#divErrorInfo").show();
                            window.location.hash = "";
                            window.location.hash = "divErrorInfo";
                            setTimeout(function () {
                                $("#divErrorInfo").hide();
                            }, 3000);
                        }
                        else if (operation == "Edit") {
                            $("#divShowInfo").html("Personal information updated failed!");
                            $("#divShowInfo").show();
                            window.location.hash = "";
                            window.location.hash = "divShowInfo";
                            $("#divShowInfo").css("color", "#d94d27");
                        }
                    }
                    else if (data == "Sending email failed!") {
                        $("#divErrorInfo").html(data);
                        $("#divErrorInfo").show();
                        setTimeout(function () {
                            $("#divErrorInfo").hide();
                        }, 10000);
                        $ritzUserID.focus();
                    }
                    else if (data == "Email to repeat") {
                        $("#divErrorInfo").html("This email address is already associated with an account. If this account is yours, you can reset your password.");
                        $("#divErrorInfo").show();
                        $("#txtCreateEmailAddress").val("");
                        $("#txtFirstName").val("");
                        $("#txtLastName").val("");
                        $("#txtPhoneNum1").val("");
                        $("#txtCreatePassword").val("");
                        $("#txtCreateConfirmPassword").val("");
                        $(".togglePassword").each(function () {
                            const targetId = $(this).attr("data-target");
                            const passwordField = $("#" + targetId);

                            if (passwordField.val() === "") {
                                $(this).hide(); 
                            } else {
                                $(this).show(); 
                            }
                        });
                        setTimeout(function () {
                            $("#divErrorInfo").hide();
                        }, 10000);
                        $ritzUserID.focus();
                    }
                    else {
                        if (operation == "Add") {
                            $("#divShowInfo").html("Thank you for registering. Please follow the link in your email to confirm your account.");
                            $("#divShowInfo").show();
                            $("#txtCreateEmailAddress").val("");
                            $("#txtFirstName").val("");
                            $("#txtLastName").val("");
                            $("#txtPhoneNum1").val("");
                            $("#txtCreatePassword").val("");
                            $("#txtCreateConfirmPassword").val("");
                            $(".togglePassword").each(function () {
                                const targetId = $(this).attr("data-target");
                                const passwordField = $("#" + targetId);

                                if (passwordField.val() === "") {
                                    $(this).hide();
                                } else {
                                    $(this).show();
                                }
                            });
                            window.location.hash = "";
                            window.location.hash = "divShowInfo";
                            setTimeout(function () {
                                $("#divShowInfo").fadeOut("slow");
                                ClearCookie();
                                if ($("#hidKey").val() != "") {
                                    window.location = "/Booking/Account?UniqueKey=" + $("#hidKey").val();
                                }
                                else {
                                    window.location = "/Account/SignIn";
                                }
                            }, 10000);
                        }
                        else if (operation == "Edit") {
                            var userName = trim($firstName.val()) + " " + trim($lastName.val());
                            $(".account-user__name").text(userName);
                            $("#divShowInfo").html("Personal information updated successfully!");
                            $("#divShowInfo").show();
                            window.location.hash = "";
                            window.location.hash = "divShowInfo";
                            GetCustomerInfo("PersonalInfo", operation);
                            setTimeout(function () {
                                $("#divShowInfo").fadeOut("slow");
                            }, 10000);
                        }
                    }
                },
                error: function () {
                }
            });

        }
        else if (operation == "Add") {
            $.ajax({
                type: 'POST',
                url: "/Account/SaveAccountInformation",
                data: {
                    "jsonObj": JSON.stringify(clientMod), "operation": operation
                },
                dataType: "text",
                beforeSend: function () {
                    $("#imgLoader").css("display", "initial");
                },
                success: function (data) {
                    $("#imgLoader").hide();
                    if (data == "failed") {
                        if (operation == "Add") {
                            $("#divErrorInfo").html("Create failed!");
                            $("#divErrorInfo").show();
                            window.location.hash = "";
                            window.location.hash = "divErrorInfo";
                            setTimeout(function () {
                                $("#divErrorInfo").hide();
                            }, 3000);
                        }
                        else if (operation == "Edit") {
                            $("#divShowInfo").html("Personal information updated failed!");
                            $("#divShowInfo").show();
                            window.location.hash = "";
                            window.location.hash = "divShowInfo";
                            $("#divShowInfo").css("color", "#d94d27");
                        }
                    }
                    else if (data == "Sending email failed!") {
                        $("#divErrorInfo").html(data);
                        $("#divErrorInfo").show();
                        setTimeout(function () {
                            $("#divErrorInfo").hide();
                        }, 10000);
                        $ritzUserID.focus();
                    }
                    else if (data == "Email to repeat") {
                        $("#divErrorInfo").html("This email address is already associated with an account. If this account is yours, you can reset your password.");
                        $("#divErrorInfo").show();
                        $("#txtCreateEmailAddress").val("");
                        $("#txtFirstName").val("");
                        $("#txtLastName").val("");
                        $("#txtPhoneNum1").val("");
                        $("#txtCreatePassword").val("");
                        $("#txtCreateConfirmPassword").val("");
                        $(".togglePassword").each(function () {
                            const targetId = $(this).attr("data-target");
                            const passwordField = $("#" + targetId);

                            if (passwordField.val() === "") {
                                $(this).hide();
                            } else {
                                $(this).show();
                            }
                        });
                        setTimeout(function () {
                            $("#divErrorInfo").hide();
                        }, 10000);
                        $ritzUserID.focus();
                    }
                    else {
                        if (operation == "Add") {
                            $("#divShowInfo").html("Thank you for registering. Please follow the link in your email to confirm your account.");
                            $("#divShowInfo").show();
                            $("#txtCreateEmailAddress").val("");
                            $("#txtFirstName").val("");
                            $("#txtLastName").val("");
                            $("#txtPhoneNum1").val("");
                            $("#txtCreatePassword").val("");
                            $("#txtCreateConfirmPassword").val("");
                            $(".togglePassword").each(function () {
                                const targetId = $(this).attr("data-target");
                                const passwordField = $("#" + targetId);

                                if (passwordField.val() === "") {
                                    $(this).hide();
                                } else {
                                    $(this).show();
                                }
                            });
                            window.location.hash = "";
                            window.location.hash = "divShowInfo";
                            setTimeout(function () {
                                $("#divShowInfo").fadeOut("slow");
                                ClearCookie();
                                if ($("#hidKey").val() != "") {
                                    window.location = "/Booking/Account?UniqueKey=" + $("#hidKey").val();
                                }
                                else {
                                    window.location = "/Account/SignIn";
                                }
                            }, 10000);
                        }
                        else if (operation == "Edit") {
                            var userName = trim($firstName.val()) + " " + trim($lastName.val());
                            $(".account-user__name").text(userName);
                            $("#divShowInfo").html("Personal information updated successfully!");
                            $("#divShowInfo").show();
                            window.location.hash = "";
                            window.location.hash = "divShowInfo";
                            GetCustomerInfo("PersonalInfo", operation);
                            setTimeout(function () {
                                $("#divShowInfo").fadeOut("slow");
                            }, 10000);
                        }
                    }
                },
                error: function () {
                }
            });
        }
    }
}

function ChangeAreaCode(obj, str) {
    var $obj = $(obj).next();
    InputValidation($obj, str, 'number');
}
function emailvail(obj) {
    if ($(obj).val() == "") {
        $(obj).addClass("field-error");
        $(obj).next().html("* Required");
        return true;
    } else {
        $(obj).removeClass("field-error");
        $(obj).next().html("");
        var Email = $(obj).val().trim();
        var patten = new RegExp(/^[\w\-\.]+@[\w\-\.]+(\.\w+)+$/);
        if (!patten.test(Email)) {
            $(obj).addClass("field-error");
            $(obj).next().html("Invalid email address");
            return true;
        }

    }
    return false;
}

function ClearErrMsg(obj) {
    $("#txtSend_error").html("");
}

function ClearCookie() {
    $.cookie('loginType', '', {
        expires: -1
    });
    $.cookie('userName', '', {
        expires: -1
    });
}


function AgencyRegister() {
    return; 
    var agencyObj = {};
    agencyObj.AgencyUserId = $('#txtAgencyEmail').val();
    agencyObj.AgencyCode = $('#txtAgencyCode').val();
    agencyObj.CompanyName = $('#txtAgencyName').val();
    agencyObj.CompanyAddress = $('#txtAgencyAddress').val();
    agencyObj.Password = $('#txtAgencyPassword').val();
    var retypePassword = $('#txtAgencyPasswordRetype').val();
    agencyObj.PhoneNumber = $('#txtAgencyPhone').val();
    if (agencyObj.AgencyUserId == "" || agencyObj.AgencyCode == "" || agencyObj.CompanyName == "" || agencyObj.CompanyAddress == "" || agencyObj.PhoneNumber == "") {
        ShowInfo("Please complete agency information.", false);
        return;
    }
    if (!RegisterInputValidation(agencyObj.AgencyUserId, "email")) {
        ShowInfo("Please input correct email account.", false);
        return;
    }
    if (!RegisterInputValidation(agencyObj.PhoneNumber, "phone")) {
        ShowInfo("Please input correct phone number.", false);
        return;
    }
    if (agencyObj.Password != retypePassword) {
        ShowInfo("Password is not same as retype.", false);
        return;
    }
    var jsonObj = JSON.stringify(agencyObj);
    $.ajax({
        type: 'POST',
        url: "/AccountAjax/CreateAgencyAccount",
        data: { "jsonObj": jsonObj },
        dataType: "json",
        beforeSend: function () {
            $("#imgAgencyRegisterLoader").css("display", "initial");
        },
        success: function (data) {
            if (data.result) {
                ShowInfo(data.msg, true);
            }
            else {
                ShowInfo(data.msg, false);
            }
        },
        complete: function () {
            $("#imgAgencyRegisterLoader").css("display", "none");
        }
    });
}

function AgencyVerify() {
    $('#divVerifyError').hide();
    var agencyCode = $('#txtVerifyAgencyCode').val();
    if (agencyCode == undefined || agencyCode.trim() == "") {
        return;
    }

    $.ajax({
        type: 'POST',
        url: "/AccountAjax/VerifyAgencyCode",
        data: { "agencyCode": agencyCode },
        dataType: "json",
        beforeSend: function () {
            $("#imgAgencyVerifyLoader").css("display", "initial");
        },
        success: function (data) {
            if (data.result) {
                $('#hidAgencyId').val(data.agencyInfo.Id);
                UpdateAgencyInfoInDiv(data.agencyInfo);
                AgentSignInTabChange(1);
            } else {
                $('#divVerifyError').show();
                $('#hidAgencyId').val(0);
            }
        },
        complete: function () {
            $("#imgAgencyVerifyLoader").css("display", "none");
        }
    });
}

function UpdateAgencyInfoInDiv(agencyObject) {
    $("#lblAgencyCode").text(agencyObject.AgencyCode);
    $("#lblAgencyName").text(agencyObject.CompanyName);
    $("#lblAgencyAddress").text(agencyObject.CompleteAddress);
    $("#lblAgencyPhone").text(agencyObject.PhoneNumber);
    $("#lblAgencyEmail").text(agencyObject.AgencyUserId);
}
function AgentSignInTabChange(step) {
    $('.tabchange_selected').removeClass('tabchange_selected');
    $('.tabchange_tbox').hide();
    if (step == undefined)
        step = 0;
    switch (step) {
        case 0:
            $('#divAgencyVerify').addClass('tabchange_selected');
            $('#divAgencyVerify').show();
            $('p[name="private"]').show();
            break;
        case 1:
            $('#divAgencyInfo').addClass('tabchange_selected');
            $('#divAgencyInfo').show();
            $('p[name="private"]').hide();
            break;
        case 2:
            $('#divAgentInfo').addClass('tabchange_selected');
            $('#divAgentInfo').show();
            $('p[name="private"]').show();
            break;
        default:
            $('#divAgencyVerify').addClass('tabchange_selected');
            $('#divAgencyVerify').show();
            $('p[name="private"]').show();
            break;
    }
}
const agentRecaptchaTokens = {};
const agentTokenTimes = {};
const agentTokenGenerating = {};
const AGENT_TOKEN_EXPIRE_TIME_MS = 3000;

function AgentWithTimeout(promise, timeoutMs) {
    return Promise.race([
        promise,
        new Promise((_, reject) => setTimeout(() => reject(new Error("Timeout")), timeoutMs))
    ]);
}

async function AgentGenerateRecaptchaToken(actionName, retry = 0) {
    const MAX_RETRY = 3;         // 最多重试 3 次
    const TIMEOUT_MS = 3000;     // 超时 3 秒

    if (tokenGenerating[actionName]) {
        return agentRecaptchaTokens[actionName];
    }

    tokenGenerating[actionName] = true;

    try {
        const token = await AgentWithTimeout(
            grecaptcha.execute('6Lc9S_gZAAAAAAsjBtJY5KAp07kMxAdUEX2PU5Ed', { action: actionName }),
            TIMEOUT_MS
        );

        agentRecaptchaTokens[actionName] = token;
        agentTokenTimes[actionName] = Date.now();

        // 成功时清除状态
        tokenGenerating[actionName] = false;

        return token;
    }
    catch (err) {
        console.error(`Token attempt ${retry + 1} failed:`, err);

        // 失败时清除状态
        tokenGenerating[actionName] = false;

        if (retry < MAX_RETRY) {
            await new Promise(r => setTimeout(r, 300));
            return AgentGenerateRecaptchaToken(actionName, retry + 1);
        }

        console.error("ReCaptcha token generation failed after multiple retries.");
        return null;
    }
}

async function RecaptchaBeforeCreateAgent() {
    const actionName = 'agent_form_submit';

    const tokenExpired =
        !agentRecaptchaTokens[actionName] ||
        (Date.now() - agentTokenTimes[actionName]) > AGENT_TOKEN_EXPIRE_TIME_MS;

    if (tokenExpired) {
        console.warn("Token expired or missing. Trying to refresh...");
        const newToken = await AgentGenerateRecaptchaToken(actionName);

        if (!newToken) {
            return false;
        }
    }

    const token = agentRecaptchaTokens[actionName];

    return new Promise((resolve) => {
        $.ajax({
            url: "/Home/GoogleRecaptcha",
            type: "POST",
            data: { captchaResponse: token, action: actionName },
            success: function (res) {
                if (res.success) {
                    console.log(`[Recaptcha Success] Score: ${res.score}`);
                    resolve(true);
                } else {
                    console.error(`Recaptcha failed: ${res.message}`);
                    resolve(false);
                }
            },
            error: function (xhr) {
                console.error("Error in backend ReCaptcha validation:", xhr.responseText);
                resolve(false);
            }
        });
    });
}

async function AgentRegister() {
    var agentObj = {};
    agentObj.UserEmail = $('#txtAgentEmail').val();
    agentObj.FirstName = $('#txtAgentFirstName').val();
    agentObj.LastName = $('#txtAgentLastName').val();
    agentObj.Password = $('#txtAgentPassword').val();
    agentObj.Password2 = $('#txtAgentPassword').val();
    var retypePassword = $('#txtAgentPasswordRetype').val();
    agentObj.Phone1 = $('#txtAgentPhone').val();
    agentObj.AgencyCode = $('#lblAgencyCode').text();
    if (agentObj.UserEmail.trim() == "" || agentObj.FirstName.trim() == "" || agentObj.LastName.trim() == "" || agentObj.Password2.trim() == "" || agentObj.Phone1.trim() == "") {
        ShowInfo("Please complete agent information", false);
        return;
    }
    if (agentObj.Password2 != retypePassword) {
        ShowInfo("Password is not same as retype.", false);
        return;
    }
    var agencyID = $('#hidAgencyId').val();
    if (agencyID <= 0) {
        ShowInfo("Please verify Agency Code(IATA) first.", false);
        return;
    }
    var jsonObj = JSON.stringify(agentObj);
    var flag = InputValidation($('#txtAgentPassword'), 'AgentPassword', 'password') && InputValidation($('#txtAgentPasswordRetype'), 'AgentPasswordRetype', 'password');
    if (flag) {
        const captchaOK = await RecaptchaBeforeCreateAgent();
        if (!captchaOK) {
            return false;
        }
        $.ajax({
            type: 'POST',
            url: "/AccountAjax/CreateAgentAccount",
            data: { "jsonObj": jsonObj, "agencyId": agencyID },
            dataType: "json",
            beforeSend: function () {
                $("#imgAgentRegisterLoader").css("display", "initial");
            },
            success: function (data) {
                if (data.result) {
                    ShowInfo(data.msg, true);
                    ClearCookie();
                    ClearAgentRegisterInfo();
                } else {
                    ShowInfo(data.msg, false);
                }
            },
            complete: function () {
                $("#imgAgentRegisterLoader").css("display", "none");
            }
        });
    }
}

function ClearAgentRegisterInfo() {
    $('#txtAgentEmail').val('');
    $('#txtAgentFirstName').val('');
    $('#txtAgentLastName').val('');
    $('#txtAgentPassword').val('');
    $('#txtAgentPasswordRetype').val('');
    $('#txtAgentPhone').val('');
    $(".togglePassword").each(function () {
        const targetId = $(this).attr("data-target");
        const passwordField = $("#" + targetId);

        if (passwordField.val() === "") {
            $(this).hide(); 
        } else {
            $(this).show();
        }
    });
}

function AgencySignIn() {
    var agencyAccount = $('#txtAgencySignInEmail').val();
    var agencyPassword = $('#txtAgencySignInPassword').val();
    if (agencyAccount.trim() == "") {
        ShowLoginError("Please input agency email account.", "divAgencyLoginError");
        return;
    }
    if (agencyPassword.trim() == "") {
        ShowLoginError("Please input password.", "divAgencyLoginError");
        return;
    }
    var changekey = $('#changeKey').val();

    if (changekey != '') {
        $.ajax({
            type: 'POST',
            url: "/AccountAjax/AgencyForgetPasswordLogin",
            data: { "emailAccount": agencyAccount, "changeKey": changekey, "password": agencyPassword },
            dataType: "json",
            beforeSend: function () {
                
            },
            success: function (data) {
                if (data.result) {
                    window.location.href = "/Agent/ChangePassword?changekey=" + data.changekey + "&type=" + data.type;
                }
                else {
                    ShowLoginError(data.msg, "divAgencyLoginError");
                }
            },
            complete: function () {
            }
        });
    }
    else {
        $.ajax({
            type: 'POST',
            url: "/AccountAjax/AgencySignIn",
            data: { "account": agencyAccount, "password": agencyPassword },
            dataType: "json",
            beforeSend: function () {
            },
            success: function (data) {
                if (data.result) {
                    window.location.href = "/Agent/AgencyInfo";
                }
                else {
                    ShowLoginError(data.msg, "divAgencyLoginError");
                }
            },
            complete: function () {
            }
        });
    }
}

function ShowAgencyPartial(e, agencyId) {
    var section = $(e).parent(".accordion");
    var contentDIV = $(e).next("div[name='partialInfo']");
    var contentType = $(e).data('whichone');
    if ($(section).attr('data-state') == "close" || $(section).attr('data-state') == undefined) {
        HideAllAgencyPartial();
        $.ajax({
            type: 'POST',
            url: "/Agent/GetAgencyAccount",
            data: { "agencyId": agencyId, "contentType": contentType },
            dataType: "html",
            beforeSend: function () {

            },
            success: function (data) {
                $(contentDIV).html(data);
                $(section).attr('data-state', 'open');
                setTimeout(function () {
                    $(contentDIV).find(".accordion__body").css("max-height", "100%");
                    $(contentDIV).find(".accordion__body").css("opacity", "1");
                    $(contentDIV).show("500");
                }, 100);

            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                if (XMLHttpRequest.status == 1001) {
                    eval(XMLHttpRequest.ResponseText);
                } else {
                }
            },
            complete: function () {
            }
        });
    }
    else {
        HideAllAgencyPartial();
    }

}



function HideAllAgencyPartial() {
    $("div[name='partialInfo']").each(function (i, e) {
        $(e).find(".accordion__body").css("max-height", "0");
        $(e).find(".accordion__body").css("opacity", "0");
        $(e).hide("500");
    });
}

function UpdatePasswordForAgency(agencyId) {
    var newPassword = $("#txtNewPassword");
    var confirmPassword = $("#txtConfirmPassword");
    var flag = true;
    $("#ShowMsg").html("");
    $("#ShowMsg").removeClass("UpdateFailed").removeClass("UpdateSuccess");
    flag = InputValidation(newPassword, "Password", "password") && InputValidation(confirmPassword, 'ConfirmPassword', 'password');
    if (flag) {
        if ($(newPassword).val() != $(confirmPassword).val()) {
            flag = false;
            $("#divConfirmPasswordErr").html("The passwords you entered must be the same.");
            $("#divConfirmPasswordErr").show();
            return;
        }
        else {
            $("#divConfirmPasswordErr").hide();

            $.ajax({
                type: 'POST',
                url: "/Agent/UpdateAgencyPassword",
                data: { "agencyId": agencyId, "newpassword": $(confirmPassword).val() },
                dataType: "json",
                success: function (data) {
                    if (data.result) {
                        $("#ShowMsg").addClass("UpdateSuccess");
                    }
                    else {
                        $("#ShowMsg").addClass("UpdateFailed");
                    }

                    $("#ShowMsg").html(data.msg);
                    $("#ShowMsg").show();
                    setTimeout(function () {
                        $("#ShowMsg").fadeOut("slow");

                    }, 4500);
                }
            });
        }
    }
    else {

    }
}

function UpdateAgencyInfo(agencyId) {
    var emailAccount = $("#txtAgencyEmail").val();
    var flag = false;
    var agencyEmailDom = $("#txtAgencyEmail");
    var companyNameDom = $("#txtCompanyName");
    var companyAddressDom = $("#txtCompanyAddress");

    flag = InputValidation(agencyEmailDom, 'AgencyEmail', 'email') && InputValidation(companyNameDom, 'CompanyName', 'companyname') && InputValidation(companyAddressDom, 'CompanyAddress', 'companyaddress');

    var agencyEmail = $(agencyEmailDom).val();
    var companyName = $(companyNameDom).val();
    var companyAddress = $(companyAddressDom).val();
    $("#UpdateAgencyInfoMsg").removeClass("UpdateSuccess").removeClass("UpdateFailed");
    $("#UpdateAgencyInfoMsg").html("");
    if (flag) {
        $.ajax({
            type: 'POST',
            url: "/Agent/UpdateAgencyInformation",
            data: { "agencyId": agencyId, "newEmail": agencyEmail, "newName": companyName, "newAddress": companyAddress },
            dataType: "json",
            success: function (data) {
                if (data.result) {
                    $("#UpdateAgencyInfoMsg").addClass("UpdateSuccess");
                }
                else {
                    $("#UpdateAgencyInfoMsg").addClass("UpdateFailed");
                }

                $("#UpdateAgencyInfoMsg").html(data.msg);
                $("#UpdateAgencyInfoMsg").show();
                setTimeout(function () {
                    $("#UpdateAgencyInfoMsg").fadeOut("slow");

                }, 4500);
            }
        });
    }
}

function AgentSignIn() {
    var agentAccount = $('#txtAgentSignInEmail').val();
    var agentPassword = $('#txtAgentSignInPassword').val();
    if (agentAccount.trim() == "") {
        ShowLoginError("Please input agent email account.", "divAgentLoginError");
        return;
    }
    if (agentPassword.trim() == "") {
        ShowLoginError("Please input password.", "divAgentLoginError");
        return;
    }
    flag = InputValidationLoginPassword($("#txtAgentSignInPassword"), 'AgentSignInPassword', 'password');
    var changekey = $('#changeKey').val();
    if (flag) {
        if (changekey != '') {
            $.ajax({
                type: 'POST',
                url: "/AccountAjax/AgentForgetPasswordLogin",
                data: { "emailAccount": agentAccount, "changeKey": changekey, "password": agentPassword },
                dataType: "json",
                beforeSend: function () {
          
                },
                success: function (data) {
                    if (data.result) {
                        window.location.href = "/Agent/ChangePassword?changekey=" + data.changekey + "&type=" + data.type;
                    }
                    else {
                        ShowLoginError(data.msg, "divAgentLoginError");
                    }
                },
                complete: function () {
          
                }
            });
        }
        else {
            $.ajax({
                type: 'POST',
                url: "/AccountAjax/AgentSignIn",
                data: { "account": agentAccount, "password": agentPassword},
                dataType: "json",
                beforeSend: function () {
                },
                success: function (data) {
                    if (data.result) {
                        
                        if (data.passwordtype == "temp") {
                            window.location.href = "/Agent/ChangePassword?changekey=" + data.changekey + "&type=" + data.type;
                        }
                        else {
                            if (data.isOldKey) {
                                window.location.href = "/Agent/ChangePassword?changekey=" + data.changekey + "&type=" + data.type + "&isOldKey=true";
                            }
                            else {
                                var redirectUrl = "/Agent/UpcomingTrips";
                                window.location.href = redirectUrl;
                            }
                        }
                    }
                    else {
                        ShowLoginError(data.msg, "divAgentLoginError");
                        if (data.msg == "This account is a client. Please sign in from /account/signin.") {
                            var redirectUrl = "/Account/SignIn";
                            setTimeout(function () { window.location.href = redirectUrl; }, 3000);
                        }
                    }
                },
                complete: function () {
                    
                }
            });
        }
    }
}

function AgencyForgotPassword(e) {
    var url = $(e).data("url");
    if (emailvail("#txtForgotEmail")) {
        return false;
    }
    $.ajax({
        type: 'POST',
        url: '/Agent/AgencyForgotPassword',
        data: { "forgotEmail": $("#txtForgotEmail").val(), "url": url },
        beforeSend: function () {
            $("#imgLoader").css("display", "initial");

        },
        async: false,
        error: function () {
        },
        success: function (data) {
            $("#divFogotErrorInfo").html(data.data);
            $("#divFogotErrorInfo").show();
            $("#wait").hide();
            if (data.flag) {
                $(e).hide();
            }

            setTimeout(function () { $("#divFogotErrorInfo").fadeOut("slow"); }, 3000);
            $("#imgLoader").hide();
        },
        error: function () {
            $("#imgLoader").hide();
            window.location = "error";
            $("#divcover").hide();
        }
    })
}
function ShowInfo(message, isSuccess) {
    if (isSuccess) {
        $("#divShowInfo").html(message);
        $("#divShowInfo").show();

        window.location.hash = "";
        window.location.hash = "divShowInfo";
        setTimeout(function () {
            $("#divShowInfo").fadeOut("slow");

        }, 15000);
    }
    else {
        $("#divErrorInfo").html(message);
        $("#divErrorInfo").show();
        window.location.hash = "";
        window.location.hash = "divErrorInfo";
        setTimeout(function () {
            $("#divErrorInfo").fadeOut("slow");

        }, 15000);
    }
}
function ShowLoginError(message, divId) {
    $("#" + divId).html(message);
    $("#" + divId).show();
    setTimeout(function () {
        $("#" + divId).fadeOut("slow");

    }, 15000);
}

function ClientSignOut() {
    $.ajax({
        type: "post",
        url: "/Account/ClearCookie",
        data: {},
        success: function (result) {
            window.location.href = "/";
        },
        error: function (e) {
            alert(e.statusText)
        }
    });
}

function AgentSignOut() {
    $.ajax({
        type: "post",
        url: "/Account/ClearCookie",
        data: {},
        success: function (result) {
            var url = "/";
            window.location.href = url;
        },
        error: function (e) {
            alert(e.statusText)
        }
    });
}

function GetLanguage() {
    if (window.location.href.toLowerCase().indexOf("/en/") >= 0 || window.location.href.toLowerCase().indexOf("/en-us/") >= 0) {
        return "en";
    }
    else {
        return "zh-cn";
    }
}

function SaveAgentInfo() {
    var firstName = $('#txtFirstName').val();
    var lastName = $('#txtLastName').val();
    var phoneNumber = $('#txtPhoneNum1').val();
    var agentUserId = $('#hidEmailAddress').val();
    if (firstName == undefined || firstName == "" || lastName == undefined || lastName == "" || phoneNumber == undefined || phoneNumber == "") {
        return;
    }
    $.ajax({
        type: "post",
        url: "/Agent/SaveAgentInfo",
        data: { "firstName": firstName, "lastName": lastName, "phone": phoneNumber, "agentUserId": agentUserId },
        success: function (data) {
            if (data.result) {
                $("#divShowInfo").html(data.msg);
                $("#divShowInfo").show();
                window.location.hash = "";
                window.location.hash = "divShowInfo";
                setTimeout(function () {
                    $("#divShowInfo").fadeOut("slow");

                }, 5000);
            }
            else {
                $("#divErrorInfo").html(data.msg);
                $("#divErrorInfo").show();
                window.location.hash = "";
                window.location.hash = "divErrorInfo";
                setTimeout(function () {
                    $("#divErrorInfo").fadeOut("slow");

                }, 5000);
            }
        },
        complete: function () {

        }
    });

}
function IsRemove(Id, whichOne, clientUserId) {
    $("#remove-" + whichOne).on("click", function () {
        DeleteAnInformation(Id, whichOne, clientUserId);
    });
}


function PassportNumberTextCounter(passportNumObj) {
    var countryId = $(passportNumObj).parent().parent().parent().find("#sltNationality").val(); 
    var number = 15;
    var charcnt = $(passportNumObj).val().length;
    switch (countryId) {
        case "233":
        case "182":
        case "124":
        case "157":
            Number = 8;
            break;
        case "38":
            number = 9;
            if (charcnt == 8) {
                number = 8;
            }
            break;
        default:
            number = 15;
            break;
    }
    if (charcnt > number) {
        $(passportNumObj).val($(passportNumObj).val().substring(0, number));
    }
    if (!(/^[0-9a-zA-Z]+$/).test($(passportNumObj).val())) {
        $(passportNumObj).val($(passportNumObj).val().substring(0, $(passportNumObj).val().length - 1));
    }
    return;
}

function NationalityChange(obj) {
    var countryId = $(obj).val();
    var number = 15;
    switch (countryId) {
        case "233": 
        case "182":
        case "124":
        case "157":
            number = 9;
            break;
        case "38":
            number = 9;
            if ($("#txtPassportNum").val().length == 8) {
                number = 8;
            }
            break;
        default:
            number = 15;
            break;
    }
    if ($("#txtPassportNum").val().length > number) {
        $("#txtPassportNum").val("");
    }
}
function MiddleCheck(obj) {
    if ($(obj).is(':checked')) {
        $("#divMiddleNameErr").hide();
        $("#txtMiddleName").val("");
    }
}
$(document).ready(function () {
    var autocomplete;
    autocomplete = new google.maps.places.Autocomplete((document.getElementById("txtAddressLine1")), {
        types: ['geocode'],
    });

    google.maps.event.addListener(autocomplete, 'place_changed', function () {
        let address = autocomplete.getPlace().address_components;
        let mod_addr = {};
        mod_addr["street_number"] = "";
        address.forEach(a => {
            if (a.types.includes("street_number")) {
                mod_addr["street_number"] = a['long_name'];
            }
            if (a.types.includes("route")) {
                mod_addr["route"] = a['long_name'];
            }
            if (a.types.includes("locality")) {
                mod_addr["city"] = a['long_name'];
            }
            if (a.types.includes("administrative_area_level_1")) {
                mod_addr["state"] = a['long_name'];
            }
            if (a.types.includes("country")) {
                mod_addr["country"] = a['long_name'];
            }
            if (a.types.includes("postal_code")) {
                mod_addr["postalcode"] = a['long_name'];
            }
        });
        $("#txtAddressLine1").val((mod_addr.route) ? mod_addr.street_number + ' ' + mod_addr.route : '');
        $("#txtZipCode").val(mod_addr.postalcode);
        $("#txtCity").val(mod_addr.city);
        var country = mod_addr.country;
        if (country == "United States") {
            country = "USA";
        }
        var countryId = $('#sltCountry option:contains("' + country + '")').val();
        if (countryId != undefined) {
            $('#sltCountry').val(countryId);
            LinkageState($('#sltCountry'), mod_addr.state);
        } else {
            $('#sltCountry').val("");
            $("#sltState").val("");
        }
    });
});



function GetRewardsInfo(whichOne, operation) {
    var affordableWorldUserId = $("#hidEmailAddress").val();
    var $divInfo = $("#div" + whichOne);
    var section = $divInfo.parent(".accordion");
    var clientType = $("#hidType").val();
    var language = "zh";
    if (window.location.href.indexOf("/en/") >= 0) {
        language = "en";
    }
    if (section.attr('data-state') == "close" || section.attr('data-state') == undefined || (operation == "Delete" || operation == "Add" || operation == "Edit" || operation == "Back")) {
        HideDiv(operation);
        if (whichOne != null && whichOne != "" && whichOne != undefined) {
            $.ajax({
                type: "post",
                data: {
                    "whichOne": whichOne,
                    "clientType": clientType
                },
                url: "/Account/GetRewardsInfo",
                datatype: "json",
                success: function (result) {
                    $("#divReadyToUse").html("");
                    $("#divPendingReward").html("");
                    $("#divjiangli").html("");
                    //后续可能要加几个模块
                    if ($divInfo != undefined) {
                        section.attr('data-state', 'open');
                        $divInfo.html(result);
                        setTimeout(function () {
                            $divInfo.find(".accordion__body").css("max-height", "100%");
                            $divInfo.find(".accordion__body").css("opacity", "1");
                            $divInfo.show("500");
                        }, 100);
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    if (XMLHttpRequest.status === 401) {
                        // 未登录，整页跳转到登录页
                        window.location.href = "/Account/SignIn";
                    }
                    else if (XMLHttpRequest.status === 1001) {
                        // 老逻辑：服务器返回脚本（例如 eval("window.location.href='/Account/SignIn';")）
                        eval(XMLHttpRequest.responseText);
                    }
                    else {
                        // 其他错误，可以考虑提示用户
                        console.error("AJAX error:", textStatus, errorThrown);
                    }
                }
            });
        }
    }
    else {
        HideDiv(operation);
    }
}